#include "stdio.h"
#include "conio.h"
#define M 21
struct stack{
  int myTop;
  char items[M];
};
void push(stack *s, char);
void pop(stack *s, char *);
int  empty(stack *s);
void popAndTest(stack *s, char *x, int *underflow);
void topAndTest(stack *s, char *x, int *underflow);
int  isOperand(char);
void convert(char[], char[]);
int  pred(char, char);
int main()
{
   char infix[M], postfix[M];
   int i;
   clrscr();
   printf("Enter an infix expression:");
   gets(infix);
   convert(infix, postfix);
   printf("Postfix expression is:");
   for(i = 0; postfix[i]; i++)
      printf("%c ", postfix[i]);
   getch();
   return 0;
}
//*****************
void convert(char infix[], char postfix[])
{
  char symbol, topSymbol;
  int underflow, i, j = 0;
  stack s;
  s.myTop = -1;
  for(i = 0; infix[i]; i ++)
  {
       symbol = infix[i];
       if(isOperand(symbol))
	   postfix[j++] = symbol;
       else  if(symbol == '(')
	       push(&s, symbol);
       else if(symbol == ')')
       {
	   pop(&s, &topSymbol);
	   while(topSymbol != '(')
	   {
	      postfix[j++] = topSymbol;
	      pop(&s, &topSymbol);
	   }//end of while
       } //end of else if
       else
       {
	      topAndTest(&s, &topSymbol, &underflow);
	      //if op1 > op2 then true
	      if(empty(&s) || (!pred(topSymbol, symbol)))
		  push(&s, symbol);
	      else
	      {
		 popAndTest(&s, &topSymbol, &underflow);
		 while(pred(topSymbol, symbol) && !underflow)
		 {
		     postfix[j++] = topSymbol;
		     popAndTest(&s, &topSymbol, &underflow);
		 }
		 push(&s, symbol);
	      } //end of else
       }//end of else
  }//end of for
  while(!empty(&s))
  {
	pop(&s, &topSymbol);
	postfix[j++] = topSymbol;
  }
  postfix[j] = '\0';
}
//*****************
int isOperand(char symbol)
{
   if(symbol >= '0' && symbol <= '9')
       return 1;
   return 0;
}
//***********************
void push(stack *s, char x)
{
       s -> items[++(s -> myTop)] = x;
}
//*******************
void pop(stack *s, char *x)
{
     *x = s -> items[(s -> myTop) --];
}
//*************************
void popAndTest(stack *s, char *x, int *underflow)
{
   if(empty(s))
     *underflow = 1;
   else
   {
     *x = s -> items[(s -> myTop) --];
     *underflow = 0;
   }
}
//*******************
void topAndTest(stack *s, char *x, int *underflow)
{
   if(empty(s))
     *underflow = 1;
   else
   {
     *x = s -> items[s -> myTop];
     *underflow = 0;
   }
}
//*****************
int empty(stack *s)
{
   if(s -> myTop == -1)
      return 1;
   else
      return 0;
}
//****************
int pred(char op1, char op2)
{
    int i, p1, p2;
    /*  ( + - * / % */
    static char op[] = {'(','+', '-', '*', '/','%','\0'};
    static int isp[] = {0, 12, 12, 13, 13, 13};
    for(i = 0; op[i]; i ++)
	if(op[i] == op1)
	{
	   p1 = i;
	   break;
	}
    for(i = 0; op[i]; i ++)
	if(op[i] == op2)
	{
	   p2 = i;
	   break;
	}
    if(isp[p1] >= isp[p2])
       return 1;
    return 0;
}

